<?php
include 'koneksi.php';
session_start();
if (!isset($_SESSION['status']) || $_SESSION['status'] !== "login") {
    header('location:login.php');
    exit();
}
if ($_SESSION['role'] !== 'apoteker' && $_SESSION['role'] !== 'kepala_puskesmas' && $_SESSION['role'] !== 'petugas') {
    header('Location: logout.php');
    exit();
}

$role = $_SESSION['role'];

$query_notif = "SELECT n.*, o.nama_obat 
                FROM notifikasi n
                LEFT JOIN obat o ON n.id_obat = o.id_obat
                WHERE n.role = '$role'
                ORDER BY n.id_notif DESC";
$result_notif = mysqli_query($conn, $query_notif);

$query_count = "SELECT COUNT(*) as total 
                FROM notifikasi 
                WHERE role = '$role' AND status = 'BARU'";
$result_count = mysqli_query($conn, $query_count);
$count_data = mysqli_fetch_assoc($result_count);
$jumlah_notif_baru = $count_data['total'];

// Tentukan menu apa yang ditampilkan berdasarkan role
$menu_config = [
    'apoteker' => ['obat', 'stok', 'gudang', 'supplier', 'scan', 'eoq', 'rop', 'pembelian', 'pengeluaran'],
    'kepala_puskesmas' => ['obat', 'stok', 'gudang', 'supplier', 'scan', 'eoq', 'rop', 'pembelian', 'pengeluaran'],
    'petugas' => ['obat', 'scan', 'stok', 'gudang', 'pengeluaran']
];

$allowed_menus = $menu_config[$role] ?? [];

function hasMenu($menu_name, $role) {
    global $allowed_menus;
    return in_array($menu_name, $allowed_menus);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Stockify</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="codedthemes">
    <link rel="icon" href="assets/images/logo.png" type="image/x-icon">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap"
        id="main-font-link">
    <link rel="stylesheet" href="assets/fonts/tabler-icons.min.css">
    <link rel="stylesheet" href="assets/fonts/feather.css">
    <link rel="stylesheet" href="assets/fonts/fontawesome.css">
    <link rel="stylesheet" href="assets/fonts/material.css">
    <link rel="stylesheet" href="assets/css/style.css" id="main-style-link">
    <link rel="stylesheet" href="assets/css/style-preset.css">
    <style>
        .notification-item {
            transition: all 0.3s ease;
            cursor: pointer;
        }
        .notification-item:hover {
            background-color: #f8f9fa;
        }
        .notification-item.unread {
            background-color: #e3f2fd;
            border-left: 3px solid #2196F3;
        }
        .notification-badge {
            position: relative;
        }
        .notification-text {
            white-space: pre-line;
            font-size: 0.875rem;
            line-height: 1.5;
        }
        .kategori-badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
        }
    </style>
</head>
<body>
    <div class="loader-bg">
        <div class="loader-track">
            <div class="loader-fill"></div>
        </div>
    </div>
    <nav class="pc-sidebar">
        <div class="navbar-wrapper">
            <div class="m-header">
                <a href="dashboard.php" class="b-brand text-primary">
                    <img src="assets/images/banner.png" style="width: 190px;">
                </a>
            </div>
            <div class="navbar-content">
                <ul class="pc-navbar">
                    <li class="pc-item pc-caption">
                        <label>Home</label>
                        <i class="ti ti-dashboard"></i>
                    </li>
                    <li class="pc-item">
                        <a href="dashboard<?= $role ?>.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-dashboard"></i></span>
                            <span class="pc-mtext">Dashboard</span>
                        </a>
                    </li>
                    
                    <?php if (hasMenu('obat', $role) || hasMenu('stok', $role) || hasMenu('gudang', $role) || hasMenu('supplier', $role) || hasMenu('scan', $role)): ?>
                        <li class="pc-item pc-caption">
                            <label>Master Data</label>
                            <i class="ti ti-dashboard"></i>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('obat', $role)): ?>
                        <li class="pc-item">
                            <a href="obatapoteker.php" class="pc-link">
                                <span class="pc-micon"><i class="ti ti-pill"></i></span>
                                <span class="pc-mtext">Obat</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('stok', $role)): ?>
                        <li class="pc-item">
                            <a href="stokapoteker.php" class="pc-link">
                                <span class="pc-micon"><i class="ti ti-stack"></i></span>
                                <span class="pc-mtext">Stok</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('gudang', $role)): ?>
                        <li class="pc-item">
                            <a href="gudangapoteker.php" class="pc-link">
                                <span class="pc-micon"><i class="ti ti-building-warehouse"></i></span>
                                <span class="pc-mtext">Gudang</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('supplier', $role)): ?>
                        <li class="pc-item">
                            <a href="supplierapoteker.php" class="pc-link">
                                <span class="pc-micon"><i class="ti ti-plus"></i></span>
                                <span class="pc-mtext">supplier</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('scan', $role)): ?>
                        <li class="pc-item">
                            <a href="scanapoteker.php" class="pc-link">
                                <span class="pc-micon"><i class="ti ti-barcode"></i></span>
                                <span class="pc-mtext">Scan</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('eoq', $role) || hasMenu('rop', $role)): ?>
                        <li class="pc-item pc-caption">
                            <label>Perhitungan</label>
                            <i class="ti ti-dashboard"></i>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('eoq', $role)): ?>
                        <li class="pc-item">
                            <a href="eoqapoteker.php" class="pc-link">
                                <span class="pc-micon"><i class="ti ti-rotate-clockwise"></i></span>
                                <span class="pc-mtext">EOQ</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('rop', $role)): ?>
                        <li class="pc-item">
                            <a href="ropapoteker.php" class="pc-link">
                                <span class="pc-micon"><i class="ti ti-refresh"></i></span>
                                <span class="pc-mtext">ROP</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('pembelian', $role) || hasMenu('pengeluaran', $role)): ?>
                        <li class="pc-item pc-caption">
                            <label>Transaksi</label>
                            <i class="ti ti-dashboard"></i>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('pembelian', $role)): ?>
                        <li class="pc-item">
                            <a href="pembelianapoteker.php" class="pc-link">
                                <span class="pc-micon"><i class="ti ti-login"></i></span>
                                <span class="pc-mtext">Pembelian</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (hasMenu('pengeluaran', $role)): ?>
                        <li class="pc-item">
                            <a href="pengeluaranapoteker.php" class="pc-link">
                                <span class="pc-micon"><i class="ti ti-adjustments-alt"></i></span>
                                <span class="pc-mtext">Mutasi</span>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
    <header class="pc-header">
        <div class="header-wrapper">
            <div class="me-auto pc-mob-drp">
                <ul class="list-unstyled">
                    <li class="pc-h-item header-mobile-collapse">
                        <a href="#" class="pc-head-link head-link-secondary ms-0" id="sidebar-hide">
                            <i class="ti ti-menu-2"></i>
                        </a>
                    </li>
                    <li class="pc-h-item pc-sidebar-popup">
                        <a href="#" class="pc-head-link head-link-secondary ms-0" id="mobile-collapse">
                            <i class="ti ti-menu-2"></i>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="ms-auto">
                <ul class="list-unstyled">
                    <?php if ($role !== 'petugas'): ?>
                        <li class="dropdown pc-h-item">
                            <a class="pc-head-link head-link-secondary dropdown-toggle arrow-none me-0" 
                               data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                <i class="ti ti-bell"></i>
                                <?php if ($jumlah_notif_baru > 0): ?>
                                    <span class="badge bg-danger rounded-pill position-absolute" style="top: 5px; right: 5px; font-size: 0.65rem;">
                                        <?= $jumlah_notif_baru > 99 ? '99+' : $jumlah_notif_baru ?>
                                    </span>
                                <?php endif; ?>
                            </a>
                            <div class="dropdown-menu dropdown-notification dropdown-menu-end pc-h-dropdown" style="width: 400px;">
                                <div class="dropdown-header d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">
                                        Notifikasi 
                                        <?php if ($jumlah_notif_baru > 0): ?>
                                            <span class="badge bg-warning rounded-pill ms-1"><?= $jumlah_notif_baru ?></span>
                                        <?php endif; ?>
                                    </h5>
                                    <?php if ($jumlah_notif_baru > 0): ?>
                                        <a href="javascript:void(0)" onclick="bacaSemuaNotifikasi()" 
                                           class="link-primary text-decoration-underline" style="font-size: 0.875rem;">
                                            Baca Semua
                                        </a>
                                    <?php endif; ?>
                                </div>
                                <div class="dropdown-header px-0 text-wrap header-notification-scroll position-relative" 
                                     style="max-height: calc(100vh - 215px); overflow-y: auto;">
                                    <?php if (mysqli_num_rows($result_notif) > 0): ?>
                                        <?php while ($notif = mysqli_fetch_assoc($result_notif)): ?>
                                            <div class="notification-item p-3 border-bottom <?= $notif['status'] == 'BARU' ? 'unread' : '' ?>" 
                                                 onclick="bacaNotifikasi(<?= $notif['id_notif'] ?>)">
                                                <div class="d-flex align-items-start">
                                                    <div class="flex-shrink-0">
                                                        <?php
                                                        $icon = 'ti-bell';
                                                        $bg_color = 'bg-primary';
                                                        if ($notif['kategori'] == 'STOK_MINIMUM') {
                                                            $icon = 'ti-alert-triangle';
                                                            $bg_color = 'bg-warning';
                                                        } elseif ($notif['kategori'] == 'KADALUWARSA') {
                                                            $icon = 'ti-calendar-x';
                                                            $bg_color = 'bg-danger';
                                                        } elseif ($notif['kategori'] == 'PEMESANAN_BARU') {
                                                            $icon = 'ti-shopping-cart';
                                                            $bg_color = 'bg-success';
                                                        }
                                                        ?>
                                                        <div class="avtar avtar-s <?= $bg_color ?>">
                                                            <i class="ti <?= $icon ?>"></i>
                                                        </div>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <div class="d-flex justify-content-between align-items-center mb-1">
                                                            <span class="badge kategori-badge <?= $bg_color ?> text-white">
                                                                <?= str_replace('_', ' ', $notif['kategori']) ?>
                                                            </span>
                                                            <?php if ($notif['status'] == 'BARU'): ?>
                                                                <span class="badge bg-info" style="font-size: 0.65rem;">BARU</span>
                                                            <?php endif; ?>
                                                        </div>
                                                        <?php if ($notif['nama_obat']): ?>
                                                            <h6 class="mb-1" style="font-size: 0.875rem;">
                                                                <strong><?= $notif['nama_obat'] ?></strong>
                                                            </h6>
                                                        <?php endif; ?>
                                                        <div class="notification-text text-muted">
                                                            <?= nl2br(htmlspecialchars($notif['pesan'])) ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <div class="text-center py-4">
                                            <i class="ti ti-bell-off" style="font-size: 3rem; color: #ccc;"></i>
                                            <p class="text-muted mt-2">Tidak ada notifikasi</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </li>
                    <?php endif; ?>
                    
                    <li class="dropdown pc-h-item header-user-profile">
                        <a class="pc-head-link head-link-primary dropdown-toggle arrow-none me-0" data-bs-toggle="dropdown"
                            href="#" role="button" aria-haspopup="false" aria-expanded="false">
                            <img src="assets/images/user.png" alt="user-image" class="user-avtar">
                            <span><i class="ti ti-settings"></i></span>
                        </a>
                        <div class="dropdown-menu dropdown-user-profile dropdown-menu-end pc-h-dropdown">
                            <div class="dropdown-header text-center">
                                <h4>Selamat Datang, <span class="medium text-muted"><?= $_SESSION['username'] ?></span></h4>
                                <p class="text-muted mb-0">
                                    <small><?= ucwords(str_replace('_', ' ', $_SESSION['role'])) ?></small>
                                </p>
                                <hr>
                                <div class="profile-notification-scroll position-relative"
                                    style="max-height: calc(100vh - 280px)">
                                    <a href="logout.php" class="dropdown-item">
                                        <i class="ti ti-logout"></i>
                                        <span>Logout</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </header>